/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.cec;

import com.ibm.hsc.auiml.databeans.cec.CUoDMemoryActivateImmediate;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.hsc.common.util.GeneralUtil;
import com.ibm.hsc.common.util.HMCDynamicPanelManager;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.Hashtable;
import java.util.Vector;

public class CUoDMemoryActivateImmediateDialog
implements TaskActionListener {
    private UserTaskManager _utm = null;
    private Hashtable _vectors = null;
    private MOXContainerObj _obj = null;
    private CUoDMemoryActivateImmediate _bean = null;
    private String _increment = "1";
    Object[] _pInfoArgs = new Object[3];
    private boolean _isCurrentlyInUse = false;

    public void showDialog(MOXContainerObj mOXContainerObj) {
        this._obj = mOXContainerObj;
        this._bean = new CUoDMemoryActivateImmediate();
        this._bean.load();
        if (!this.setBeanInfo(mOXContainerObj)) {
            return;
        }
        try {
            DataBean[] dataBeanArray = new DataBean[]{this._bean};
            HMCDynamicPanelManager.setMetalLookAndFeel();
            AuimlAdapter auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.cec.CUoDMemoryActImmedWizard", "MemAIWizard", dataBeanArray);
            auimlAdapter.init();
            this._utm = auimlAdapter.getUserTaskManager();
            int n = Integer.parseInt(this._bean.getNumMemNotPermInUse());
            this._utm.setAttribute("MemAIWizardPanel1.NewInUseSpinBox", 29, "" + n);
            this._utm.setAttribute("MemAIWizardPanel1.NewInUseSpinBox", 28, "" + this._increment);
            this._utm.setAttribute("MemAIWizardPanel1.NewInUseSpinBox", 30, "" + this._increment);
            this._utm.addCommitListener((TaskActionListener)this);
            auimlAdapter.showIt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        CUoDMemoryActivateImmediateDialog cUoDMemoryActivateImmediateDialog = new CUoDMemoryActivateImmediateDialog();
        cUoDMemoryActivateImmediateDialog.showDialog(null);
    }

    private boolean setBeanInfo(MOXContainerObj mOXContainerObj) {
        int n;
        Hashtable hashtable = null;
        String string = (String)mOXContainerObj.getPropertyValue("name");
        String string2 = (String)mOXContainerObj.getPropertyValue("modelType_PROP") + "*" + (String)mOXContainerObj.getPropertyValue("serialNumber_PROP");
        try {
            this._pInfoArgs[0] = string;
            this._pInfoArgs[1] = mOXContainerObj.getHost().getName();
            this._pInfoArgs[2] = string2;
            hashtable = (Hashtable)mOXContainerObj.getMOClass().invokeStaticMethod("cuodMemoryInfo", this._pInfoArgs);
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                System.out.println(" Failed to invoke cuodMemoryInfo...");
                exception.printStackTrace();
            }
            String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEMORY_INFO_ERROR_TITLE");
            HSCLogUtils.clientLog(exception, HSCLogUtils._CECClassLogInfo);
            HSCLogUtils.displayError(exception, string3, HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEMORY_INFO_ERROR"));
            return false;
        }
        Vector<MOXContainerObj> vector = new Vector<MOXContainerObj>();
        vector.add(mOXContainerObj);
        String string4 = (String)hashtable.get("CUOD_AMOUNT_MEM_INSTALLED");
        try {
            n = Integer.parseInt(string4) / 1024;
            string4 = Integer.toString(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._increment = (String)hashtable.get("CUOD_MEMORY_INCREMENT");
        if (IDebug.enabled) {
            System.err.println("MKS: CUoDMemoryActivateImmediateDialog.setBeanInfo() Increment value -- " + this._increment);
        }
        this._bean.setNumMemInstalled(string4);
        this._bean.setNumMemPermInUse((String)hashtable.get("CUOD_AMOUNT_MEM_PERM_IN_USED"));
        this._bean.setNumMemNotPermInUse((String)hashtable.get("CUOD_AMOUNT_MEM_NOT_PERM_IN_USED"));
        this._bean.setIncrementValue(Integer.parseInt(this._increment));
        try {
            n = this.checkForActivateImmediateState(hashtable) ? 1 : 0;
            if (n == 0) {
                return false;
            }
            int n2 = Integer.parseInt(this._bean.getNumMemNotPermInUse());
            if (n2 == 0) {
                String string5 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMED_MEM_NOT_PERM_HAS_ZERO_ERROR", "There is ZERO permanently unused memory. Hence this task is not valid");
                String string6 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_ERROR_TITLE", "Trial CoD Error");
                ErrorPanel errorPanel = new ErrorPanel(string5, string6);
                errorPanel.show();
                return false;
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                exception.printStackTrace();
            }
            String string7 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_NOT_PERM_READ_ERROR", "Not Permanently used value is incorrect");
            String string8 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_NOT_PERM_READ_ERROR_TITLE", "Parsing Error");
            ErrorPanel errorPanel = new ErrorPanel(string7, string8);
            errorPanel.show();
            return false;
        }
        return true;
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        String string = taskActionEvent.getActionCommand();
        if (string.equals("ACTIVATED")) {
            if (this._utm == null) {
                this._utm = (UserTaskManager)taskActionEvent.getSource();
            }
            if (this._utm != null) {
                this._utm.refreshElement("MemAIWizardPanel2.NumMemPermImmNewString");
            }
        } else if (string.equals("COMPLETE")) {
            if (this._isCurrentlyInUse) {
                return;
            }
            this._isCurrentlyInUse = true;
            try {
                Object[] objectArray = new Object[4];
                int n = (int)this._bean.getNumMemImmInUseNewSpinVal();
                objectArray[0] = this._pInfoArgs[0];
                objectArray[1] = new Integer(n);
                objectArray[2] = this._pInfoArgs[1];
                objectArray[3] = this._pInfoArgs[2];
                if (IDebug.enabled) {
                    System.err.println("Arguments are: ");
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        System.err.println(" Arg " + n2 + " -- " + objectArray[n2]);
                        ++n2;
                    }
                }
                this._obj.getMOClass().invokeStaticMethod("activateImmedMemory", objectArray);
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    throwable.printStackTrace();
                }
                this._isCurrentlyInUse = false;
                String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_ERROR_TITLE");
                String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_GENERAL_ERROR");
                GeneralUtil.handleException(throwable, string2, string3);
                return;
            }
            this._isCurrentlyInUse = false;
        }
    }

    private boolean checkForActivateImmediateState(Hashtable hashtable) {
        try {
            int n = Integer.parseInt((String)hashtable.get("CUOD_MEM_ACT_IMMED_CONDITION"));
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEM_ACTIVATE_IMMEDIATE_NOT_STATE_ERROR_TITLE", "Trial CoD Memory State Error");
            String string2 = null;
            if ((n & 0xFFFF) == 128) {
                string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEM_ACTIVATE_IMMEDIATE_IN_USE");
            } else if ((n & 0xFFFF) == 255) {
                string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEM_ACTIVATE_IMMEDIATE_NOLONGER_ALLOWED");
            } else if ((n & 0xFFFF) != 1) {
                string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEM_ACTIVATE_IMMEDIATE_UNKNOWN_STATE");
            }
            if (string2 != null) {
                ErrorPanel errorPanel = new ErrorPanel(string2, string);
                errorPanel.show();
            }
            return string2 == null;
        }
        catch (Exception exception) {
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEM_ACTIVATE_IMMEDIATE_STATE_ERROR");
            String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_MEM_ACTIVATE_IMMEDIATE_NOT_STATE_ERROR_TITLE");
            ErrorPanel errorPanel = new ErrorPanel(string, string3);
            errorPanel.show();
            return false;
        }
    }
}

